###Aav11 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'Aav11 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(15,15,15,20,28),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### Aav11 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'Aav11 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(15, 15, 15,15, 20),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### At11 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'At11 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(15,15,15,20, 59),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("**", "*", "*",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))

### At11 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'At11 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(15, 15, 15,15, 23),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("**", "***", "*",'*',"*"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))



### At22 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'At22 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(15,15,15,20, 59),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"*"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))

### At22 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'At22 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(15, 15, 15,15, 23),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"*"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))



### At44 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'At44 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(15,15,15,20, 32),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("*", "**", "NS",'*',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### At44 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'At44 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(15, 15, 15,15, 20),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "**",'**',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))




### He11 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'He11 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(30,34,34,50,75),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'**',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### He11 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'He11 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(30,32,32,32,40),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))




### Av11 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'Av11 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(20,20,20,20,55),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "*", "NS",'NS',"*"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))

### Av11 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'Av11 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(20,20,20,20,30),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "*", "*",'NS',"*"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))



### At20 Trehalose
#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'At20 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(30,32,32,50,83),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'*',"***"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))

### At20 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Motif.xlsx', sheet = 'At20 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose:Motif)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(30,32,32,48,80),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'*',"***"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))




